//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net;
using System.Threading;
using System.Text;
using System.IO;

namespace ServicePointDemo
{
	public class RequestState
	{
		private StringBuilder _RequestData;
		internal byte[] _bufferRead;
		public HttpWebRequest Request;
		public Stream ResponseStream;
		
		public RequestState()
		{
			_bufferRead = new byte[1024];
			_RequestData = new StringBuilder();
			Request = null;
			ResponseStream = null;
		}
     
		public StringBuilder RequestData
		{
			get
			{
				return _RequestData;
			}
			set 
			{
				_RequestData = value;
			}
		}
	}

	/// <summary>
	/// Podsumowanie dla ServicePointTest.
	/// </summary>
	class ServicePointTest
	{
		public static ManualResetEvent allDone = null;
		public static int NumRequests = 100;
		public static int NumConnections = 4;
		public static int GlobalCallbackCounter = 0;

		static void Main(string[] args)
		{
			string [] addresses = {"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetauthorizationclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetcookieclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetcookiecollectionclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetcookiecontainerclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetcookieexceptionclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetcredentialcacheclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetdnsclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetdnspermissionclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetdnspermissionattributeclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetendpointclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetendpointpermissionclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetfilewebrequestclasstopic.asp",
									"http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpref/html/frlrfsystemnetfilewebresponseclasstopic.asp"};
			if(args.Length == 1)
			{
				NumConnections = Convert.ToInt32(args[0]);
			}

			ServicePointManager.DefaultConnectionLimit = NumConnections;

			for (int j = 0;j < 5;j++)
			{
				int start = 0;
				int end = 0;
				int total = 0;
				GlobalCallbackCounter = 0;			
				allDone = new ManualResetEvent(false);
				start = Environment.TickCount;
		
				try
				{	
					GetPages(addresses);
				}
				catch(WebException webex)
				{
					Console.WriteLine(webex.ToString());			
				}
			
				allDone.WaitOne();
				end = Environment.TickCount;				
				total = end - start;
			
				Console.WriteLine(total);
			}
		}

		public static void GetPages(string [] addresses)
		{			

			int i;
			for (i=0; i < NumRequests; i++)
			{
				foreach(string address in addresses)
				{
					HttpWebRequest	Request = (HttpWebRequest)WebRequest.Create(address);
					RequestState requestState = new RequestState();
					Request.ServicePoint.ConnectionLimit = NumConnections;
					Request.Pipelined = false; 
					requestState.Request = Request;
					Request.BeginGetResponse(new AsyncCallback(RespCallback), requestState);
				}
			}			
           		
			return;			
		}
		private static void RespCallback(IAsyncResult ar)
		{
			GlobalCallbackCounter++;
			
			RequestState rs = (RequestState)ar.AsyncState;			
			HttpWebRequest req = rs.Request;
			req.ServicePoint.ConnectionLimit = NumConnections;			
			WebResponse theResponse = (WebResponse) req.EndGetResponse(ar);
			const int BUFFER_SIZE = 1024;									
			
			Stream ResponseStream = theResponse.GetResponseStream();
			rs.ResponseStream = ResponseStream;
			IAsyncResult iarRead = ResponseStream.BeginRead(rs._bufferRead, 0, BUFFER_SIZE, new AsyncCallback(ReadCallBack), rs);
		}

		private static void ReadCallBack(IAsyncResult asyncResult)
		{
			RequestState rs = (RequestState)asyncResult.AsyncState;
			Stream responseStream = rs.ResponseStream;
			int read = responseStream.EndRead( asyncResult );

			if (read > 0)
			{
				rs.RequestData.Append(Encoding.ASCII.GetString(rs._bufferRead, 0, read));			
				
				IAsyncResult ar = responseStream.BeginRead( rs._bufferRead, 0, 1024, new AsyncCallback(ReadCallBack), rs);
				//IAsyncResult ar2 = responseStream.BeginRead( rs._bufferRead, 0, 1024, new AsyncCallback(ReadCallBack), rs);
			}
			else
			{
				if(rs.RequestData.Length>1)
				{
					// W tym momencie mona ju co zrobi ze stron,
					// poniewa wszystkie dane zostay odczytane.
					//string strContent;						
					//strContent = rs.RequestData.ToString();
					//Console.Write(strContent.Length.ToString());
					//Console.Write(".");
				}
				
				responseStream.Close();
				
				if (GlobalCallbackCounter == NumRequests)
				{
					allDone.Set();
				}				
			}
			return;
		}
	}
}
